# Security Policy

## Reporting a Vulnerability

At Hi.Events, we take the security of our software seriously. If you discover a security vulnerability, we would appreciate your help in disclosing it to us in a responsible manner. We ask that you do not publicly disclose the vulnerability until we have had a chance to address it.

### Urgent Issues

For urgent security issues, please email us directly at [security@hi.events](mailto:security@hi.events). This will ensure that your report is promptly received and reviewed by our security team.

### Non-Urgent Issues

For non-urgent security issues, please create an issue in our GitHub repository using the following link: [https://github.com/HiEventsDev/hi.events/issues](https://github.com/HiEventsDev/hi.events/issues). Please ensure that the issue is labeled appropriately to indicate that it is a security concern.

## Security Update Policy

- We aim to respond to initial reports within 48 hours.
- We will provide an estimated timeline for addressing the vulnerability.
- We will notify the reporter when the vulnerability has been addressed.

## Best Practices for Reporting

When reporting a security issue, please include as much of the following information as possible to help us better understand the nature and scope of the issue:

- A description of the vulnerability and its impact.
- Steps to reproduce the issue, including any relevant code snippets or screenshots.
- Any potential mitigations or workarounds that might be applicable.
- Your contact information for any follow-up questions.
- The version of the software you are using.
- Any other relevant information that might help us understand the issue

## Responsible Disclosure Policy

We believe in responsible disclosure and are committed to working with the security community to verify, reproduce, and respond to all legitimate reports. We appreciate the efforts of security researchers and practitioners who help make the open-source ecosystem a safer place.


## Thank You

Thank you for helping us keep Hi.Events secure!

For any questions or clarifications, feel free to reach out to us at [security@hi.events](mailto:security@hi.events).

##  Hi.Events Public Key

If you need to send us encrypted information, you can use our public key below:

```plaintext

-----BEGIN PGP PUBLIC KEY BLOCK-----

mQINBGZjdAkBEADMU2Qkkh+N24HOs8Ne6OqnFOIbmONE2+X6zxTjJ18SJ/Yp1WAl
TpoUgSZpmqLlava2KD93I3lfJO5dD1ojzeWk+dWXy9SqHTQ7kA5i3OF5HXSEvkpM
p3TIPzNMaIC2kuBHDann7S9Uhhm/+j2GEZtcru3g1XpxRRlDd+8EsSFYcU9h8l2f
Zg455TFR8uv5YWiVGw6E1UCZxbYw9VEvYRVuOPoj6HKrvt/B7DKrpfLspIFW7ne3
8g5RDsEEMypJlmutXC0wkS5UenIGHcnO7bMsObATKlfCengIFGwbXJbfYinVL1X5
ESpoaV6ix5eA/EmzDw54gvN3MjryQamseN6w8cqrdovv1c/ClELS4Z8lOQ7GU7fr
yEmjviBtVwe4Xc+JTrEInrXpo6zETTnLzKKuUnz9d+THWHPTd2KHOPvp6b3OH0Vw
9f/1yBfEd+oX+1OGf2ZzxH0Gp/IYHRxuUfrjjNlXd6j/f5cIG1tOhpNfOh2ycyxr
lAgYAecoibp0I3YlVIHOmxgRDgq3DOCFdDhjdHb5eCf7YErq0jdoPa9VpnsWOySX
jVY4HnKZawfbS0Udkw35GAOhvQ08OpFJq7TQgG190qz3nTk3WPRjppBT9hB4/Ouh
V5c5k9M1rVRdblY8NQcdYboEUlhPndmoLUebgTGV9BuuNZ/nEX1JFNT7xQARAQAB
tB5IaS5FdmVudHMgPHNlY3VyaXR5QGhpLmV2ZW50cz6JAk4EEwEIADgWIQQU0/Ko
4evMN2+/tTEBK+Cfu6CeZQUCZmN0CQIbAwULCQgHAgYVCgkICwIEFgIDAQIeAQIX
gAAKCRABK+Cfu6CeZf99D/40Sxi5mh941m5Z1zp+Kd36o1XfRWMMCk4YA8UrxHfq
N1+pFImynWa5tioJnIunxX/yciQFhK6UqK0m+QPujXNjLHgTvbMstP411MhnnKRV
iAAhQ9V+mbB3sXXYT6nMabYg8w8uRQZjcGa6VLRdmQ9AGFc2isw+aSkFP3RUaEoW
GLuhDHuZZp9MoSf0vuTg8/vhUr8R6O1VuBMaVqDnisEUTy1GK0Zk3BgIm7fGBexM
hPY3I75FNxO++LHYiRBeqCAO3v3HPKmSrZwqiTVzlpRXYTn304Br6OtMWns2TSGi
MxQ0TcRMpujPOABKE01Tvkx7R2ueuLqufT/SoilOm35+F6puXqKrwTGSL+KgaHX/
5TlkXoGrY6/jpbFt41dSB5I80VZwqzkYcAOQmxQlN0ep0DnvJOj1QHRsOSHc9ibd
NvLkF4aVEagZ38BLeQcThwJ7QolzTAiTdWJXUFnXO43c48SePrhXCwwN6KnfpvLg
DEtz7LMA58DTJhSPmprzFBhjRC3Otq/iKBukAvnUteM1QuDFHDrTPHKGqUv4r1C4
BKPyO6NPABH3UDMZGja/TlfBt1xEB/lGh89DQB/nUUKNFWZ3LTt++p11aRPWi8Nn
SoQjsW9yiqU9faZJeHmsx/Z/4ugQiash6CetNEK1PGrHy3VAH5Yc5sofJ9LZSHSw
T7kCDQRmY3QJARAAmpnO0GnfjleTXWrTiY8GVMk0atyui4/rCkN/HHdLxlj8S+9m
UjDN6d60bcBZQG2X+JGnZsD36103bP4hBu+bSdH/VfGnFjK6NVyMmhRKsv5btBKm
Fg+lXfiidvAUOYYHhB7AUDjU39UHwgAfDSBV1tlcXa842z+tAvlVG9cyV+fGJaQC
GTjvX6Golk/pKJY2/wz4iL87YAqjG9vAiSuwDaF6jl1G+YssJ1yvZ8RWVTIb35Rj
BvVgTVLLDD8fvFKlIEg9w98nOaL5UGjBcPtbODBj+zuXo9JtpC0KNlYDrkH8QDCM
TqlhhAWQ56K999h0wccE4mbTm5/RgL2bvj+sezYmgYiie9cyAhl4B2IkAqXsZFdo
bfwwD/o/Z/qQajeDQbbVsK4oNYQFjkzf+222Vp1FLcofZ0EaeWYIat5BOzvmPhgF
WcMQvygmh3ybpb1AGC1kBgD5lNJkj/niy7sJnZ+lcjsNPXow/pfRdywM8tzdQk4f
Oout6LOiZrCzwACBlehKsf6umwFnBk6Cumhz1+4vt2uo971+vEm1QzR42d5tVf01
XuJ6bI9ZYB+pRb54zaXlpjqqzkmJcBVuYhmMC1QkChCgjpLwvSHGt2uJKQbWov7q
vtujN05Srl6P3sFO38LFmPWrA+623XBVKs8GILdgzTJjIAUoDothfIg2rXcAEQEA
AYkCNgQYAQgAIBYhBBTT8qjh68w3b7+1MQEr4J+7oJ5lBQJmY3QJAhsMAAoJEAEr
4J+7oJ5lM/sP/A+lS3iqXI8SJviCGSrCCJQcA1uGnU1FIEtxkuvp3nQvJHlGnmN+
usfBRetdLMPO7CuCHIcu9+023rG/whPjmD5FHDADroug83a8igz7TCjqQ/8bgr1Z
oWRJKajnzsYzjOyXHtYL15U+LJ2nhG/WDjNp7RyL6rZ1EHcqklKl0C33EtPifs4Z
arxiNwBsZjhDkVUX///rjNr9Hb9HlfR0ml8iTcUJKmgarjSFfJ0OnAkRHcS66Gme
luXkTz+G96pNwVht3tqHZ3rCZScUeUq47ZzB7kjcEB9kJ7MAG3GkKf/JJqE44KWX
vGoaoMdw3jXNsyhGFGbPjIn1txaxeo/KKe03HKxeBOuaIK01nNDaUp3TJQkMtaId
TIerUpxUvtezVXuw2ZyVFTeSfntMujwWAolDGakslyFbDbejRJ0fN4Zwo9rQXJhy
lXrBAogM1feC/HsLdV3jZAlSUzwhEFqNG3XcbP+Ok0RyGKED0QwU8LHYwxWGgkz7
aRP7u7PmzJfjmStnqrR0E9I6lOaGL/l7TOF1UYZEbWc9qd/SZ1G6QqDMepzX6aMP
LgEGBDp/Qo6Hjh8lxONlVcagdn4M6yPQiNZdCFZV8Q56nOCH0l/ywKsNkggqvrtc
URSFSI5iNr0JSvCYNmzsDB6zSSlR/UvgRFM1SRUoG3sygmV32Onh0EzU
=YbpK
-----END PGP PUBLIC KEY BLOCK-----
```

---

Hi.Events Team
